///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef NetworkDLS_Algorithmic_Symmetric_Cipher_Cryptography_Library_NASCCL_Cpp
#define NetworkDLS_Algorithmic_Symmetric_Cipher_Cryptography_Library_NASCCL_Cpp
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "STDIO.H"
#include "Windows.H"
#include "NASCCL.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void NASCCL::MutateKey(void)
{
	Cipher(sKeyBuf, iKeySz); //Scramble the users key.
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void NASCCL::BuildSBox(void)
{
	NTYPE cValue = 0;

	for(int ilBox = 0; ilBox < SALT_BOXES; ilBox++)
	{
		for(int ilVal = 0; ilVal < SALT_VALUES; ilVal++)
		{
			if(iKeyPos == iKeySz)
			{
				iKeyPos = 0;
			}

			cValue = (sKeyBuf[iKeyPos] * ((ilVal + 1) * (ilBox + 1))) ^ sHardSalt[ilBox][(sKeyBuf[iKeyPos] ^ cValue) % 255];

			sKeySalt[ilBox][ilVal] = cValue;

			iKeyPos++;
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool NASCCL::InitializeCryptographyEx(void *lpKey, unsigned int iINKeySz, bool bAutoReset)
{
	unsigned int iPos = 0;

	ZeroKeyBox();

	//Save the size of the users key.
	iKeyPos = 0;
	iKeySz = iINKeySz;
	iSBox = 0;
	bReset = false;

	//Allocate enough RAM to store the users key.
	if((sKeyBuf = (NTYPE *) calloc(sizeof(NTYPE), iKeySz + 1)) != NULL)
	{
		//Copy the users key.
		while(iPos < iKeySz)
		{
			sKeyBuf[iPos] = ((NTYPE *)lpKey)[iPos];
			iPos++;
		}

		BuildSBox();

		MutateKey();

		bReset = bAutoReset;

		return true;
	}

	return false;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool NASCCL::InitializeCryptography(const char *sKey)
{
	return InitializeCryptographyEx((NTYPE *)sKey, strlen(sKey), false);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void NASCCL::ResetCryptography(void)
{
	iKeyPos = 0;
	iSBox = 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void NASCCL::DestroyCryptography(void)
{
	//Free the RAM used by the copy of the users key.
	free(sKeyBuf);
	sKeyBuf = NULL;

	//ZERO out the size of the users key.
	iKeySz = 0;
	iKeyPos = 0;
	iSBox = 0;

	ZeroKeyBox();
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void NASCCL::ZeroKeyBox(void)
{
	for(int ilBox = 0; ilBox < SALT_BOXES; ilBox++)
	{
		for(int ilVal = 0; ilVal < SALT_VALUES; ilVal++)
		{
			sKeySalt[ilBox][ilVal] = 0;
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void NASCCL::CipherEx(const void *lpBuf, void *lpTarget, unsigned int iBufSz)
{
	if(bReset)
	{
		ResetCryptography();
	}

	for(unsigned int iPos = 0; iPos < iBufSz; iPos++)
	{
		if(iKeyPos == iKeySz)
		{
			iKeyPos = 0;
		}

		if(iSBox == SALT_BOXES)
		{
			iSBox = 0;
		}

		((NTYPE *)lpTarget)[iPos] = (((NTYPE *)lpBuf)[iPos] ^ (sKeyBuf[iKeyPos] + sHardSalt[iSBox][sKeyBuf[iKeyPos]]));

		iKeyPos++;
		iSBox++;
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void NASCCL::Cipher(void *lpBuf, unsigned int iBufSz)
{
	CipherEx(lpBuf, lpBuf, iBufSz);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
